
from lib.daq_arburg import signal_struct

# %%

# Benutzername ist üblicherweise host_computer; falls kein PW hinterlegt ist 1 eingeben; Endpoint URL (mit IP) ist in Maschinensteurung ablesbar
CLIENT_ADDRESS = 'opc.tcp://Username:password@IP:4880/Arburg/' 
NAME_OF_MEASUREMENT = 'name_der_messung'  # Name der Messreihe, wird als Namenspräfix für die Messdatei verwendet
SLEEP_TIME = 0.25  # Zeitintervall in Sekunden, in dem nach einem neuen Zyklus gesucht werden soll


"""
Bei Messgrafiken muss die Anzahl der Signale explizit angegeben werden (num_signals=x).
Standardmäßig wird der Wert auf 1 gesetzt.
"""
SIGNALS = {
    
    'cycle_counter': signal_struct('ns=2;i=Node-ID'),  # this key must be included with the key name 'cycle_counter'!
    
        
     #Monitoring Charts (signals must be configured on the machine)
     'monitoring_chart_1': signal_struct('ns=2;i=Node-ID'),
    
    
    # Extended Monitoring Charts
     'extended_monitoring_chart_1': signal_struct('ns=2;i=Node-ID'),  
  
    
    # Measurement Charts
    'measurement_chart_1': signal_struct('ns=2;i=Node-ID', num_signals=4),
 

    # Scalar values
    'Parameter_1': signal_struct('ns=2;i=Node-ID'),
    'Parameter_2': signal_struct('ns=2;i=Node-ID'),
    
    }

# Dieses dict enthält das Signal/die Node, welche zur Erkennung eines neuen Zyklusses verwendet wird
NEW_CYCLE_SIGNAL = {
    'new_cycle_signal': signal_struct('ns=2;i=Node-ID'),
    }

OLD_CYCLE_VALUE = 0  # Wert, den die new cycle node annimmt, BEVOR neuer Zyklus erkannt werden soll
NEW_CYCLE_VALUE = 1  # Wert, den die new cycle node annimmt, wenn ein neuer Zyklus erkannt werden soll
USE_FILENAME_CYCLE_PREFIX = False  # Auf True setzen, um eine neue Datei für jeden Zyklus zu erzeugen
NEW_FILE_TIMER = 'd'  # character representing the timestep at which a new file is created ('d' = 1 per day, 'h' = 1 per hour, etc.)
